/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.jddev0.ep.block.ThermalGeneratorBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ThermalGeneratorRecipe;
import me.jddev0.ep.screen.ThermalGeneratorMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ThermalGeneratorBlockEntity
extends ConfigurableUpgradableFluidEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, SimpleFluidStorage> {
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_THERMAL_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue();

    public ThermalGeneratorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.THERMAL_GENERATOR_ENTITY, blockPos, blockState, "thermal_generator", ModConfigs.COMMON_THERMAL_GENERATOR_CAPACITY.getValue(), ModConfigs.COMMON_THERMAL_GENERATOR_TRANSFER_RATE.getValue(), FluidStorageSingleTankMethods.INSTANCE, FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_THERMAL_GENERATOR_FLUID_TANK_CAPACITY.getValue() * 1000L), UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * ThermalGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                ThermalGeneratorBlockEntity.this.method_5431();
                ThermalGeneratorBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate){

            @Override
            public long getMaxExtract() {
                return Math.max(1L, (long)Math.ceil((double)this.maxExtract * ThermalGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                ThermalGeneratorBlockEntity.this.method_5431();
                ThermalGeneratorBlockEntity.this.syncFluidToPlayers(32);
            }

            private boolean isFluidValid(FluidVariant variant) {
                if (ThermalGeneratorBlockEntity.this.field_11863 == null) {
                    return false;
                }
                List recipes = ThermalGeneratorBlockEntity.this.field_11863.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
                return recipes.stream().map(class_8786::comp_1933).map(ThermalGeneratorRecipe::getInput).anyMatch(inputs -> Arrays.stream(inputs).anyMatch(input -> variant.getFluid() == input));
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(() -> {
            if (this.field_11863 == null) {
                return 0L;
            }
            List recipes = this.field_11863.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
            long rawProduction = 0L;
            block0: for (class_8786 recipe : recipes) {
                for (class_3611 fluid : ((ThermalGeneratorRecipe)recipe.comp_1933()).getInput()) {
                    if (((SimpleFluidStorage)this.fluidStorage).getFluid().getFluid() != fluid) continue;
                    rawProduction = ((ThermalGeneratorRecipe)recipe.comp_1933()).getEnergyProduction();
                    rawProduction = (long)((double)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                    break block0;
                }
            }
            long production = (long)((float)rawProduction * ((float)Math.min(((SimpleFluidStorage)this.fluidStorage).getFluid().getMilliBucketsAmount(), 50L) / 1000.0f));
            production = Math.max(0L, Math.min(production, ((EnergizedPowerEnergyStorage)this.energyStorage).getCapacity() - ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount()));
            long fluidAmount = (long)((float)production / (float)rawProduction * 1000.0f);
            return (long)((float)(rawProduction * fluidAmount) / 1000.0f);
        }, value -> {}), new EnergyValueContainerData(() -> {
            if (this.field_11863 == null) {
                return 0L;
            }
            List recipes = this.field_11863.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
            long rawProduction = 0L;
            block0: for (class_8786 recipe : recipes) {
                for (class_3611 fluid : ((ThermalGeneratorRecipe)recipe.comp_1933()).getInput()) {
                    if (((SimpleFluidStorage)this.fluidStorage).getFluid().getFluid() != fluid) continue;
                    rawProduction = ((ThermalGeneratorRecipe)recipe.comp_1933()).getEnergyProduction();
                    rawProduction = (long)((double)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                    break block0;
                }
            }
            return (long)((double)(rawProduction * ((SimpleFluidStorage)this.fluidStorage).getFluid().getMilliBucketsAmount()) / 1000.0);
        }, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new ThermalGeneratorMenu(id, this, inventory, this.upgradeModuleInventory, this.data);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)ThermalGeneratorBlock.POWERED))) {
            ThermalGeneratorBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        ThermalGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(class_1937 level, class_2338 blockPos, class_2680 state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        List recipes = level.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
        long rawProduction = 0L;
        block5: for (class_8786 recipe : recipes) {
            for (class_3611 fluid : ((ThermalGeneratorRecipe)recipe.comp_1933()).getInput()) {
                if (((SimpleFluidStorage)blockEntity.fluidStorage).getFluid().getFluid() != fluid) continue;
                rawProduction = ((ThermalGeneratorRecipe)recipe.comp_1933()).getEnergyProduction();
                rawProduction = (long)((double)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                break block5;
            }
        }
        if (rawProduction > 0L && ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() < ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getCapacity()) {
            long production = (long)((double)rawProduction * ((double)Math.min(((SimpleFluidStorage)blockEntity.fluidStorage).getFluid().getMilliBucketsAmount(), 50L) / 1000.0));
            production = Math.max(0L, Math.min(production, ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getCapacity() - ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()));
            long fluidAmount = (long)((double)production / (double)rawProduction * 1000.0);
            production = (long)((double)(rawProduction * fluidAmount) / 1000.0);
            try (Transaction transaction = Transaction.openOuter();){
                ((SimpleFluidStorage)blockEntity.fluidStorage).extract((TransferVariant)((FluidVariant)((SimpleFluidStorage)blockEntity.fluidStorage).variant), FluidUtils.convertMilliBucketsToDroplets(fluidAmount), (TransactionContext)transaction);
                ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).insert(production, (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        long consumptionSum = 0L;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }
}

